<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Product Category Promo
 * Displays a promo for a product.
 */
 
 if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('avia_prod_promo', 'avia_please_install_woo');
	return;
}
 
add_action('wp_head','prodpromo_style');
function prodpromo_style( ){
	if(is_rtl()):
		echo '<style>@media only screen and (min-width: 768px){div.prod-promo {padding-right:calc(".$imgsize."px + 15px);}}</style>';
		echo '<style>@media only screen and (max-width: 767px){div.prod-promo {padding-right:0px !important;}}</style>';
	else:
		echo '<style>@media only screen and (min-width: 768px){div.prod-promo {padding-left:calc(".$imgsize."px + 15px);}}</style>';
		echo '<style>@media only screen and (max-width: 767px){div.prod-promo {padding-left:0px !important;}}</style>';
	endif;
}

// Don't load directly
if ( !defined('ABSPATH') ) { die('-1'); }

if ( !class_exists( 'avia_prod_promo' ) ) 
{
	class avia_prod_promo extends aviaShortcodeTemplate{
			
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$this->config['name']		= __('Product Promo', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= AviaBuilder::$path['imagesURL']."sc-heading.png";
				$this->config['order']		= 86;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'prod_promo';
				$this->config['modal_data'] = array('modal_class' => 'largescreen');
				$this->config['tooltip'] 	= __('Creates Product Promo', 'avia_framework' );
				$this->config['preview'] 	= false;
			}
			
			
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(	
							"name" 	=> __("Promo Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of promo you would like.", 'avia_framework' ),
							"id" 	=> "promo_type",
							"type" 	=> "select",
							"std" 	=> "category-promo",
							"subtype" => array( __("Product Category", 'avia_framework' )=>'category-promo',  __("Single Product", 'avia_framework' )=>'product-promo')
							), 
						
					array(
						"name" 	=> __("Which Product?", 'avia_framework' ),
						"desc" 	=> __("Select which product this promo will feature.", 'avia_framework' ),
						"id" 	=> "prod_heading",
						"type" 	=> "select",
						"taxonomy" => "single",
					    "subtype" => "product",
						"required" => array('promo_type','equals','product-promo'),
						),
						
					array(
						"name" 	=> __("Which Product Category?", 'avia_framework' ),
						"desc" 	=> __("Select which product category this promo will feature.", 'avia_framework' ),
						"id" 	=> "cat_heading",
						"type" 	=> "select",
						"taxonomy" => "product_cat",
						"required" => array('promo_type','equals','category-promo'),
					    "subtype" => "cat",
						),
						
					array(	
						"name" 	=> __("Heading Override", 'avia_framework' ),
						"desc" 	=> __("By default the promo heading will display either the product category name or single product name. Here you can override that heading with any text you would like. Leave empty to disable.", 'avia_framework' ),
						"id" 	=> "heading",
						"std" 	=> "",
						"type" 	=> "input"),
					
					array(	
							"name" 	=> __("Promo Image Size", 'avia_framework' ),
							"desc" 	=> __("Set the width & height of the promo graphic as displayed on larger screens. When viewed on mobile devices, the promo image will automatically display the 'Entry Without Sidebar' image size.", 'avia_framework' ),
							"id" 	=> "imgsize",
							"type" 	=> "select",
							"std" 	=> "125",
							"subtype" => AviaHtmlHelper::number_array(80,180,1)
							), 
							
					array(
								"name" 	=> __("Image Overrides",'avia_framework' ),
								"desc" 	=> __("By default the promo image displayed will be the category or product image attached to the entry. In some cases these images may not look ideal based on the sizes displayed. These options will allow you to override those defaults to use any image you would like.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
					array(	
						"name" 	=> __("Promo Image (desktop) Override", 'avia_framework' ),
						"desc" 	=> __("Insert the image URL which will be displayed as the round promo image. To ensure desired effect, ensure you choose a square image or modify the link appropriately to call the 'Square' image dimension as created with Enfold. Leave blank to disable.<br /><strong>EXAMPLE:</strong> https://www.yourdomain.com/wp-content/uploads/yourimage-180x180.png", 'avia_framework' ),
						"id" 	=> "desktopimg",
						"std" 	=> "",
						"container_class" => 'av_half',
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Promo Image (mobile) Override", 'avia_framework' ),
						"desc" 	=> __("Insert the image URL which will be displayed as the wide promo image. To ensure desired effect, ensure you choose a wide image or modify the link appropriately to call the 'Entry Without Sidebar' image dimension as created with Enfold. Leave blank to disable.<br /><strong>EXAMPLE:</strong> https://www.yourdomain.com/wp-content/uploads/yourimage-1210x423.png", 'avia_framework' ),
						"id" 	=> "mobileimg",
						"std" 	=> "",
						"container_class" => 'av_half',
						"type" 	=> "input"),		
							
					array(	
							"name" 	=> __("Subheading Type", 'avia_framework' ),
							"desc" 	=> __("Select a description type.<br /> - If the promo is for a category, this will display the Category Description.<br /> - If the promo is for a product, its short description will be displayed.", 'avia_framework' ),
							"id" 	=> "style",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Description", 'avia_framework' )=>'',  __("Custom", 'avia_framework' )=>'custom-sub')
							),  
				            				            
					array(
						"name" 	=> __("Subheading Text",'avia_framework' ),
						"desc" 	=> __("Add your subheading here",'avia_framework' ),
						"id" 	=> "content",
						"type" 	=> "textarea",
						"required" => array('style','not',''),
						"std" 	=> ""),   
						
					array(	"name" 	=> __("Subheading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your subeading in Pixel", 'avia_framework' ),
				            "id" 	=> "subheading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(10,40,1),
				            "std" => "15"), 
				            	
				    array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Promo Button" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(	"name" 	=> __("Button Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on your button.", 'avia_framework' ),
				            "id" 	=> "label",
				            "type" 	=> "input",
				            "std" => __("SHOP NOW", 'avia_framework' )),
				    array(	
							"name" 	=> __("Button Link?", 'avia_framework' ),
							"desc" 	=> __("Where should your button link to?", 'avia_framework' ),
							"id" 	=> "link",
							"type" 	=> "linkpicker",
							"fetchTMPL"	=> true,
							"subtype" => array(	
												__('Set Manually', 'avia_framework' ) =>'manually',
												__('Single Entry', 'avia_framework' ) =>'single',
												__('Taxonomy Overview Page',  'avia_framework' )=>'taxonomy',
												),
							"std" 	=> ""),
							
					array(	
							"name" 	=> __("Open Link in new Window?", 'avia_framework' ),
							"desc" 	=> __("Select here if you want to open the linked page in a new window", 'avia_framework' ),
							"id" 	=> "link_target",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => AviaHtmlHelper::linking_options()),	
																
					array(	
							"name" 	=> __("Button Size", 'avia_framework' ),
							"desc" 	=> __("Choose the size of your button here", 'avia_framework' ),
							"id" 	=> "size",
							"type" 	=> "select",
							"std" 	=> "small",
							"subtype" => array(
								__('Small',   'avia_framework' ) =>'small',
								__('Medium',  'avia_framework' ) =>'medium',
								__('Large',   'avia_framework' ) =>'large',
								__('X Large',   'avia_framework' ) =>'x-large',
							)),

					array(	
							"name" 	=> __("Button Icon", 'avia_framework' ),
							"desc" 	=> __("Should an icon be displayed at the left side of the button", 'avia_framework' ),
							"id" 	=> "icon_select",
							"type" 	=> "select",
							"std" 	=> "no",
							"subtype" => array(
								__('No Icon',  'avia_framework' ) =>'no',
								__('Yes, display Icon to the left',  'avia_framework' ) => 'yes' ,	
								__('Yes, display Icon to the right',  'avia_framework' ) =>'yes-right-icon',
								)),
					array(	
							"name" 	=> __("Icon Visibility",'avia_framework' ),
							"desc" 	=> __("Check to only display icon on hover",'avia_framework' ),
							"id" 	=> "icon_hover",
							"type" 	=> "checkbox",
							"std" 	=> "",
							"required" => array('icon_select','not_empty_and','no')
							),
					array(	
							"name" 	=> __("Button Icon",'avia_framework' ),
							"desc" 	=> __("Select an icon for your Button below",'avia_framework' ),
							"id" 	=> "icon",
							"type" 	=> "iconfont",
							"std" 	=> "",
							"required" => array('icon_select','not_empty_and','no')
							),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Heading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "headingcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "headingcustom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('headingcolor','equals','custom-color-heading')
						),
						
					array(	
							"name" 	=> __("Subheading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "subcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-subheading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_subfont",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('subcolor','equals','custom-color-subheading')
						),
						
					array(	
							"name" 	=> __("Button Color", 'avia_framework' ),
							"desc" 	=> __("Choose a color for your button here", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "theme-color",
							"subtype" => array(	
												__('Colored Buttons', 'avia_framework' ) => array(
												__('Theme Color', 'avia_framework' )=>'theme-color',
												__('Theme Color Highlight', 'avia_framework' )=>'theme-color-highlight',
												__('Theme Color Subtle', 'avia_framework' )=>'theme-color-subtle',
												__('Custom Color', 'avia_framework' )=>'custom',
												)),
								),
							
					array(	
							"name" 	=> __("Custom Background Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom background color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#444444",
							"required" => array('color','equals','custom')
						),	
						
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
							"required" => array('color','equals','custom')
						),	
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
					
				  
				);

			}
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				
			    extract(shortcode_atts(array('tag' => 'h3', 'promo_type'=>'', 'prod_heading'=>'', 'cat_heading'=>'', 'heading'=>'', 'headingcolor'=>'', 'subcolor' =>'', 'image_width'=>'', 'style'=>'', 'desktopimg'=>'', 'mobileimg'=>'', 'headingcustom_font'=>'', 'custom_subfont'=>'', 'size'=>'', 'subheading_active' => '', 'subheading_size'=>'', 'label' => 'SHOP NOW', 'link' => '', 'link_target' => '', 'color' => 'theme-color', 'custom_bg' => '#444444', 'custom_font' => '#ffffff', 'size' => 'small', 'position' => 'left', 'icon_select' => 'no', 'icon' => '', 'font' =>'', 'icon_hover' => '',  'imgsize' => '125'), $atts, $this->config['shortcode']));
			
        		$output  = "";
        		$styling = "";
        		$subheading = "";
        		$border_styling = "";
        		$before = $after = "";
        		$class   = $meta['el_class'];
        		$subheading_extra = "";
        		
        			// add seo markup
                    $markup = avia_markup_helper(array('context' => 'entry_title','echo'=>false, 'custom_markup'=>$meta['custom_markup']));
					
					// filter heading for & symbol and convert them					
        			$heading = apply_filters('avia_ampersand', wptexturize($heading));
        			
        			//if the heading contains a strong tag make apply a custom class that makes the rest of the font appear smaller for a better effect
        			if( strpos($heading, '<strong>') !== false ) $class .= " av-thin-font";
					if( strpos($cat_heading, '<strong>') !== false ) $class .= " av-thin-font";
					if( strpos($prod_heading, '<strong>') !== false ) $class .= " av-thin-font";
        			
        			//apply the padding styling
	        		if(is_rtl()):
						$styling .= "float:right; margin-bottom:0px; text-transform:uppercase;";
					else:
						$styling .= "float:left; margin-bottom:0px; text-transform:uppercase;";
					endif;
	        		
	        		// if the color is a custom hex value add the styling for both border and font
	        		if($headingcolor == "custom-color-heading" && $headingcustom_font)  
	        		{
	        			$styling .= "color:{$headingcustom_font};";
	        			$border_styling = "style='border-color:{$headingcustom_font}'";
	        			$subheading_extra = "av_custom_color";
	        		}
					
					if($subcolor == "custom-color-subheading" && $custom_subfont)  
	        		{
	        			$substyling .= "color:{$custom_subfont} !important;";
	        		}
	        		
	        		//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
	        		
	        		//check if we got a subheading
	        		if( ($promo_type == 'category-promo') && ( $style == 'custom-sub' ) && !empty( $content ) )
	        		{	        			
	        			$content = "<div class ='av-subheading {$subheading_extra} {$av_font_classes}' style='font-size:".$subheading_size."px; {$substyling}'><p style='padding:10px 0px;'>".$content."</p></div>";
	        		
	        			$cat_description = $content;
	        		} else {
						global $woocommerce, $product;
						$product = wc_get_product( $cat_heading );
						$prod_term = get_term($cat_heading,'product_cat');
						
						$cat_description = "<div class ='av-subheading {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'><p style='padding:10px 0px;'>".$prod_term->description."</p></div>";
					}
					
	        		if( ($promo_type == 'product-promo') && ( $style == 'custom-sub' ) && !empty( $content ) )
	        		{	        			
	        			$content = "<div class ='av-subheading {$subheading_extra} {$av_font_classes}' style='font-size:".$subheading_size."px; {$substyling}'><p style='padding:10px 0px;'>".$content."</p></div>";
	        		
	        			$prod_description = $content;
	        		} else {
						global $woocommerce, $product;
						$product = wc_get_product( $prod_heading );
						$shortdesc = $product->post->post_excerpt;
						$prod_description = "<div class ='av-subheading {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'><p style='padding:10px 0px;'>".$shortdesc."</p></div>";
					}
					
					$display_char 	= av_icon($atts['icon'], $atts['font']);
					$extraClass 	= $atts['icon_hover'] ? "av-icon-on-hover" : "";
				
					if($atts['icon_select'] == "yes") $atts['icon_select'] = "yes-left-icon";
				
					$btnstyle = "";
					if($atts['color'] == "custom") 
					{
					$btnstyle .= "style='background-color:".$atts['custom_bg']."; border-color:".$atts['custom_bg']."; color:".$atts['custom_font']."; '";
					} else {
					$btnstyle .= "style='text-decoration:none !important;'";
					}

				
			    	$blank = strpos($atts['link_target'], '_blank') !== false ? ' target="_blank" ' : "";
			    	$blank .= strpos($atts['link_target'], 'nofollow') !== false ? ' rel="nofollow" ' : "";

			    	$link  = AviaHelper::get_url($atts['link']);
			    	$link  = ( ( $link == "http://" ) || ( $link == "manually" ) ) ? "" : $link;
			    
			    	$content_html = "";
			    	if('yes-left-icon' == $atts['icon_select']) $content_html .= "<span class='avia_button_icon avia_button_icon_left ' {$display_char}></span>";
					$content_html .= "<span class='avia_iconbox_title' >".$atts['label']."</span>";
			    	if('yes-right-icon' == $atts['icon_select']) $content_html .= "<span class='avia_button_icon avia_button_icon_right' {$display_char}></span>";
					
					global $woocommerce, $product;
					$product = wc_get_product( $prod_heading );
					$product_image = get_the_post_thumbnail_url( $prod_heading, 'square' );
					$product_image_large = get_the_post_thumbnail_url( $prod_heading, 'entry_without_sidebar' );
					$prod_term = get_term($prod_heading,'product');
					$prod_name = $product->name;
					$shortdesc = $product->post->post_excerpt;
					
					$prod_category = get_terms( 'product_cat' );
					$product_cat = $cat->term_id;
					$product_cat = $cat_heading;
					$cat_thumb_id = get_woocommerce_term_meta( $product_cat, 'thumbnail_id', true );
					$cat_thumb_url = wp_get_attachment_image_url( $cat_thumb_id, 'square' );
					$cat_wide_url = wp_get_attachment_image_url( $cat_thumb_id, 'entry_without_sidebar' );
					$cat_term = get_term($cat_heading,'product_cat');
					$cat_name = $cat_term->name;
					
					$btncontent = "<a href='{$link}' class='avia-button {$extraClass} {$av_display_classes} ".$this->class_by_arguments('icon_select, color, size, position' , $atts, true)."' {$blank} {$btnstyle} >".$content_html."</a>";
				
					$btnoutput =  "<div class='avia-button-wrap avia-button-left ".$meta['el_class']."'>".$btncontent."</div>";
					
					if($promo_type == 'category-promo') {
						if(!empty($heading)){ $promo_name = $heading; } else { $promo_name = $cat_name; }
						if(!empty($desktopimg)){ $promo_image = $desktopimg; } else { $promo_image = $cat_thumb_url; }
						if(!empty($mobileimg)){ $wide_image = $mobileimg; } else { $wide_image = $cat_wide_url; }
						$description = $cat_description;
						}
					if($promo_type == 'product-promo') {
						if(!empty($heading)){ $promo_name = $heading; } else { $promo_name = $prod_name; }
						if(!empty($desktopimg)){ $promo_image = $desktopimg; } else { $promo_image = $product_image; }
						if(!empty($mobileimg)){ $wide_image = $mobileimg; } else { $wide_image = $product_image_large; }
						$description = $prod_description;
						}

	        		//html markup
					$output .= '<div class="avia-image-container av-styling-circle av-hover-grow av-small-hide av-mini-hide avia-builder-el-8 el_before_av_heading avia-builder-el-first avia-align-left {$av_display_classes}" itemscope="itemscope" itemtype="https://schema.org/ImageObject"><div class="avia-image-container-inner"><img class="avia_image " src="'.$promo_image.'" width="'.$imgsize.'" height="'.$imgsize.'" alt="" itemprop="thumbnailUrl"></div></div>';
	        		$output .= "<div class='{$promo_type} av-special-heading-h3 {$headingcolor} {$style} {$class} {$av_display_classes}'>";
	        		$output .= 	"<h3 class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$promo_name."</h3>";
	        		$output .= 	"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
					$output .= '<div class="avia-image-container  av-styling- av-hover-grow  av-desktop-hide av-medium-hide  avia-builder-el-9  el_after_av_heading  el_before_av_button   avia-align- " itemscope="itemscope" itemtype="https://schema.org/ImageObject"><div class="avia-image-container-inner"><img class="avia_image " style="margin-top:8px;" src="'.$wide_image.'" alt="" itemprop="thumbnailUrl"></div></div>';
					$output .= 	$description;
	        		$output .= "{$btnoutput}</div>";
        		
        		return $output;
        	}
	}
}
